import { world, system, ItemStack, BlockPermutation } from '@minecraft/server'

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:blue_bonnets_stage0', {
        onRandomTick: ({ block }) => {
            const stage = block.permutation.withState("v360:stage", 1)
            block.setPermutation(stage)
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:blue_bonnets_stage1', {
        onRandomTick: ({ block }) => {
            const blockState = block.permutation.getState("minecraft:cardinal_direction")
            const blueBonnets = BlockPermutation.resolve('v360:blue_bonnets', { "minecraft:cardinal_direction": blockState })
            block.setPermutation(blueBonnets)
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:blue_bonnets_honeycomb0', {
        onPlayerInteract({ block, player }) {
            const { x, y, z } = block.location
            const equipment = player.getComponent('equippable');
            const selectedItem = equipment.getEquipment('Mainhand');
            const blockState = block.permutation.getState("minecraft:cardinal_direction");
            const blueBonnetsWaxed = BlockPermutation.resolve('v360:blue_bonnets_waxed0', { "minecraft:cardinal_direction": blockState })
            if (selectedItem?.typeId === 'minecraft:honeycomb' && blockState) {
                block.dimension.runCommand(`particle v360:wax ${x} ${y + 0.5} ${z}`)
                player.runCommandAsync('clear @s minecraft:honeycomb 0 1')
                block.dimension.playSound("copper.wax.on", block.location)
                block.setPermutation(blueBonnetsWaxed)
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:blue_bonnets_honeycomb1', {
        onPlayerInteract({ block, player }) {
            const { x, y, z } = block.location
            const equipment = player.getComponent('equippable');
            const selectedItem = equipment.getEquipment('Mainhand');
            const blockState = block.permutation.getState("minecraft:cardinal_direction");
            const blueBonnetsWaxed = BlockPermutation.resolve('v360:blue_bonnets_waxed1', { "minecraft:cardinal_direction": blockState })
            if (selectedItem?.typeId === 'minecraft:honeycomb' && blockState) {
                block.dimension.runCommand(`particle v360:wax ${x} ${y + 0.5} ${z}`)
                player.runCommandAsync('clear @s minecraft:honeycomb 0 1')
                block.dimension.playSound("copper.wax.on", block.location)
                block.setPermutation(blueBonnetsWaxed)
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:blue_bonnets_bonemeal0', {
        onPlayerInteract({ block, player }) {
            const { x, y, z } = block.location
            const stage = block.permutation.withState('v360:stage', 1)
            const equipment = player.getComponent('equippable');
            const selectedItem = equipment.getEquipment('Mainhand');
            if (selectedItem?.typeId === 'minecraft:bone_meal') {
                block.setPermutation(stage)
                player.runCommandAsync('clear @s minecraft:bone_meal 0 1')
                block.dimension.playSound('item.bone_meal.use', block.location)
                block.dimension.runCommand(`particle minecraft:crop_growth_emitter ${x} ${y + 0.5} ${z}`)
            }

        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:blue_bonnets_bonemeal1', {
        onPlayerInteract({ block, player }) {
            const { x, y, z } = block.location
            const blockState = block.permutation.getState("minecraft:cardinal_direction")
            const blueBonnets = BlockPermutation.resolve('v360:blue_bonnets_block', { "minecraft:cardinal_direction": blockState })
            const equipment = player.getComponent('equippable');
            const selectedItem = equipment.getEquipment('Mainhand');
            if (selectedItem?.typeId === 'minecraft:bone_meal') {
                block.setPermutation(blueBonnets)
                player.runCommandAsync('clear @s minecraft:bone_meal 0 1')
                block.dimension.playSound('item.bone_meal.use', block.location)
                block.dimension.runCommand(`particle minecraft:crop_growth_emitter ${x} ${y + 0.5} ${z}`)
            }

        }
    })
})